%% Informationen zum Skript

% Plot eines gaussfoermigen Intensitaetsprofils mit markierter 1/e^2 Breite
% Benoetigt "Fuzzy Logic Toolbox" von Mathworks
% von Nikolas Arthkamp 2021

%% Berechnung der Verlaeufe

%Parameter festlegen
sigma = 0.25;
mu = 0;

%X-Achse festlegen
x = -1:0.01:1;

%groesse von y_grenze an x anpassen
y_grenze = x;

%gaussfoermiges Profil erzeugen
y_gauss = gaussmf(x,[sigma mu]);

%Grenze der Strahlbreite berechnen und in alle Werte von y_grenze schreiben
y_grenze(:) = max(y_gauss)*(1/exp(2));

%% Plot erstellen

%gaussfoermiges Profil
plot(x,y_gauss,'r');
hold on

%Plot der Grenze
plot(x,y_grenze,'b');
hold off

%Achsenbeschriftung
xlabel('rho');
ylabel('I(rho)');

%Titel einfuegen
title('1/e^2 Breite eines gaußförmigen Strahls');

%% Bild speichern

saveas(gcf, 'Strahlbreite.png');